% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_code_repositories}
\alias{sagemaker_list_code_repositories}
\title{Gets a list of the Git repositories in your account}
\usage{
sagemaker_list_code_repositories(CreationTimeAfter, CreationTimeBefore,
  LastModifiedTimeAfter, LastModifiedTimeBefore, MaxResults, NameContains,
  NextToken, SortBy, SortOrder)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns only Git repositories that were created after the
specified time.}

\item{CreationTimeBefore}{A filter that returns only Git repositories that were created before the
specified time.}

\item{LastModifiedTimeAfter}{A filter that returns only Git repositories that were last modified
after the specified time.}

\item{LastModifiedTimeBefore}{A filter that returns only Git repositories that were last modified
before the specified time.}

\item{MaxResults}{The maximum number of Git repositories to return in the response.}

\item{NameContains}{A string in the Git repositories name. This filter returns only
repositories whose name contains the specified string.}

\item{NextToken}{If the result of a \code{ListCodeRepositoriesOutput} request was truncated,
the response includes a \code{NextToken}. To get the next set of Git
repositories, use the token in the next request.}

\item{SortBy}{The field to sort results by. The default is \code{Name}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}
}
\value{
A list with the following syntax:\preformatted{list(
  CodeRepositorySummaryList = list(
    list(
      CodeRepositoryName = "string",
      CodeRepositoryArn = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedTime = as.POSIXct(
        "2015-01-01"
      ),
      GitConfig = list(
        RepositoryUrl = "string",
        Branch = "string",
        SecretArn = "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets a list of the Git repositories in your account.
}
\section{Request syntax}{
\preformatted{svc$list_code_repositories(
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  MaxResults = 123,
  NameContains = "string",
  NextToken = "string",
  SortBy = "Name"|"CreationTime"|"LastModifiedTime",
  SortOrder = "Ascending"|"Descending"
)
}
}

\keyword{internal}
