% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_upload_ssh_public_key}
\alias{iam_upload_ssh_public_key}
\title{Uploads an SSH public key and associates it with the specified IAM user}
\usage{
iam_upload_ssh_public_key(UserName, SSHPublicKeyBody)
}
\arguments{
\item{UserName}{[required] The name of the IAM user to associate the SSH public key with.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{SSHPublicKeyBody}{[required] The SSH public key. The public key must be encoded in ssh-rsa format or
PEM format. The minimum bit-length of the public key is 2048 bits. For
example, you can generate a 2048-bit key, and the resulting PEM file is
1679 bytes long.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\verb{\\u0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{\\u00FF})
\item The special characters tab (\verb{\\u0009}), line feed (\verb{\\u000A}), and
carriage return (\verb{\\u000D})
}}
}
\value{
A list with the following syntax:\preformatted{list(
  SSHPublicKey = list(
    UserName = "string",
    SSHPublicKeyId = "string",
    Fingerprint = "string",
    SSHPublicKeyBody = "string",
    Status = "Active"|"Inactive",
    UploadDate = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Uploads an SSH public key and associates it with the specified IAM user.

The SSH public key uploaded by this operation can be used only for
authenticating the associated IAM user to an AWS CodeCommit repository.
For more information about using SSH keys to authenticate to an AWS
CodeCommit repository, see \href{https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up.html}{Set up AWS CodeCommit for SSH Connections}
in the \emph{AWS CodeCommit User Guide}.
}
\section{Request syntax}{
\preformatted{svc$upload_ssh_public_key(
  UserName = "string",
  SSHPublicKeyBody = "string"
)
}
}

\keyword{internal}
