% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_untag_resource}
\alias{secretsmanager_untag_resource}
\title{Removes one or more tags from the specified secret}
\usage{
secretsmanager_untag_resource(SecretId, TagKeys)
}
\arguments{
\item{SecretId}{[required] The identifier for the secret that you want to remove tags from. You can
specify either the Amazon Resource Name (ARN) or the friendly name of
the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too—for example, if you
don’t include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you’re
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don’t create secret names
ending with a hyphen followed by six characters.

If you specify an incomplete ARN without the random suffix, and instead
provide the 'friendly name', you \emph{must} not include the random suffix.
If you do include the random suffix added by Secrets Manager, you
receive either a \emph{ResourceNotFoundException} or an
\emph{AccessDeniedException} error, depending on your permissions.}

\item{TagKeys}{[required] A list of tag key names to remove from the secret. You don't specify the
value. Both the key and its associated value are removed.

This parameter to the API requires a JSON text string argument. For
information on how to format a JSON parameter for the various command
line tool environments, see \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json}{Using JSON for Parameters}
in the \emph{AWS CLI User Guide}.}
}
\value{
An empty list.
}
\description{
Removes one or more tags from the specified secret.

This operation is idempotent. If a requested tag is not attached to the
secret, no error is returned and the secret metadata is unchanged.

If you use tags as part of your security strategy, then removing a tag
can change permissions. If successfully completing this operation would
result in you losing your permissions for this secret, then the
operation is blocked and returns an Access Denied error.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:UntagResource
}

\strong{Related operations}
\itemize{
\item To add one or more tags to the collection attached to a secret, use
\code{\link[=secretsmanager_tag_resource]{tag_resource}}.
\item To view the list of tags attached to a secret, use
\code{\link[=secretsmanager_describe_secret]{describe_secret}}.
}
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  SecretId = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# The following example shows how to remove two tags from a secret's
# metadata. For each, both the tag and the associated value are removed.
# There is no output from this API. To see the result, use the
# DescribeSecret operation.
svc$untag_resource(
  SecretId = "MyTestDatabaseSecret",
  TagKeys = list(
    "FirstTag",
    "SecondTag"
  )
)
}

}
\keyword{internal}
