% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_describe_protection_group}
\alias{shield_describe_protection_group}
\title{Returns the specification for the specified protection group}
\usage{
shield_describe_protection_group(ProtectionGroupId)
}
\arguments{
\item{ProtectionGroupId}{[required] The name of the protection group. You use this to identify the
protection group in lists and to manage the protection group, for
example to update, delete, or describe it.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProtectionGroup = list(
    ProtectionGroupId = "string",
    Aggregation = "SUM"|"MEAN"|"MAX",
    Pattern = "ALL"|"ARBITRARY"|"BY_RESOURCE_TYPE",
    ResourceType = "CLOUDFRONT_DISTRIBUTION"|"ROUTE_53_HOSTED_ZONE"|"ELASTIC_IP_ALLOCATION"|"CLASSIC_LOAD_BALANCER"|"APPLICATION_LOAD_BALANCER"|"GLOBAL_ACCELERATOR",
    Members = list(
      "string"
    )
  )
)
}
}
\description{
Returns the specification for the specified protection group.
}
\section{Request syntax}{
\preformatted{svc$describe_protection_group(
  ProtectionGroupId = "string"
)
}
}

\keyword{internal}
