% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{cl2eVRcent}
\alias{cl2eVRcent}
\title{The closest points among a data set in the vertex regions to the respective edges in a triangle}
\usage{
cl2eVRcent(Dt, tri, M)
}
\arguments{
\item{Dt}{A set of 2D points representing the set of data points.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri}.}
}
\value{
A \code{list} with the elements
\item{txt1}{Vertex labels are \eqn{A=1}, \eqn{B=2}, and \eqn{C=3} (corresponds to row number in Extremum Points).}
\item{txt2}{A short description of the distances as \code{"Distances to Edges in the Respective \eqn{M}-Vertex Regions"}.}
\item{type}{Type of the extrema points}
\item{desc}{A short description of the extrema points}
\item{mtitle}{The \code{"main"} title for the plot of the extrema}
\item{ext}{The extrema points, here, closest points to edges in the respective vertex region.}
\item{X}{The input data, \code{Dt}, can be a \code{matrix} or \code{data frame}}
\item{num.points}{The number of data points, i.e., size of \code{Dt}}
\item{supp}{Support of the data points, here, it is \code{tri}}
\item{cent}{The center point used for construction of vertex regions}
\item{ncent}{Name of the center, \code{cent}, it is \code{"M"} or \code{"CC"} for this function}
\item{regions}{Vertex regions inside the triangle, \code{tri}, provided as a list}
\item{region.names}{Names of the vertex regions as \code{"vr=1"}, \code{"vr=2"}, and \code{"vr=3"}}
\item{region.centers}{Centers of mass of the vertex regions inside \code{tri}}
\item{dist2ref}{Distances of closest points in the \code{M}-vertex regions to corresponding edges.}
}
\description{
An object of class \code{"Extrema"}.
Returns the closest data points among the data set, \code{Dt}, to edge \eqn{i} in \code{M}-vertex region \eqn{i} for \eqn{i=1,2,3}
in the triangle \code{tri}\eqn{=T(A,B,C)}. Vertex labels are \eqn{A=1}, \eqn{B=2}, and \eqn{C=3}, and corresponding edge labels are
\eqn{BC=1}, \eqn{AC=2}, and \eqn{AB=3}.

Vertex regions are based on center \eqn{M=(m_1,m_2)} in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri}
or based on the circumcenter of \code{tri}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);

Tr<-rbind(A,B,C);
n<-10  #try also n<-20

set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

Ext<-cl2eVRcent(dat,Tr,M)
Ext
summary(Ext)
plot(Ext)

cl2eVRcent(dat[1,],Tr,M)
cl2e<-cl2eVRcent(dat,Tr,M)
cl2e

Ds<-cp2e.tri(Tr,M)

Xlim<-range(Tr[,1],dat[,1])
Ylim<-range(Tr[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

if (dimension(M)==3) {M<-bary2cart(M,Tr)}
#need to run this when M is given in barycentric coordinates

plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(dat,pch=1,col=1)
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(cl2e$ext,pch=3,col=2)

xc<-Tr[,1]+c(-.02,.03,.02)
yc<-Tr[,2]+c(.02,.02,.04)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

txt<-rbind(M,Ds)
xc<-txt[,1]+c(-.02,.05,-.02,-.01)
yc<-txt[,2]+c(-.03,.02,.08,-.07)
txt.str<-c("M","D1","D2","D3")
text(xc,yc,txt.str)

cl2eVRcent(dat,Tr,M)

dat.fr<-data.frame(a=dat)
cl2eVRcent(dat.fr,Tr,M)

dat.fr<-data.frame(a=Tr)
cl2eVRcent(dat,dat.fr,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cl2eTbVRcent}}, \code{\link{cl2eVRCM}}, and \code{\link{cl2edgesTe}}
}
\author{
Elvan Ceyhan
}
