% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplication_estimation.R
\name{approx_response_cov_recursive}
\alias{approx_response_cov_recursive}
\title{Approximate the covariance of one response with an arbitrary product of
responses.}
\usage{
approx_response_cov_recursive(
  ids,
  r_covs,
  r_means,
  n,
  responses,
  response,
  verbose = FALSE
)
}
\arguments{
\item{ids}{Column ids of responses to use. First is taken alone while 2nd to
last are to be multiplied}

\item{r_covs}{Response covariance matrix}

\item{r_means}{Response means (vector)}

\item{n}{Sample size}

\item{responses}{List of lists with elements of class predictor}

\item{response}{Character, Either "binary" or "continuous"}

\item{verbose}{logical}
}
\value{
A vector with the approximated covariance, and approximated mean and
  variance of the product
}
\description{
Approximate the covariance of one response with an arbitrary product of
responses.
}
