% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cow_alliance.R
\name{add_cow_alliance}
\alias{add_cow_alliance}
\title{Add Correlates of War alliance data to a data frame}
\usage{
add_cow_alliance(data)
}
\arguments{
\item{data}{a dyad-year or leader-dyad-year data frame (either "directed" or "non-directed")}
}
\value{
\code{add_cow_alliance()} takes a dyad-year data frame and adds information about
the alliance pledge in that given dyad-year. These include whether there was an alliance
with a defense pledge, neutrality pledge, non-aggression pledge, or pledge for consultation
in time of crisis (entente).
}
\description{
\code{add_cow_alliance()} allows you to add Correlates of War alliance
data to a dyad-year data frame
}
\details{
Duplicates in the original directed dyad-year alliance data were pre-processed. Check
\code{cow_alliance} in the package's \code{data-raw} directory on Github for more information.

This function will also work with leader-dyad-years, though users should be careful with leader-level
applications of alliance data. Alliance data are primarily communicated yearly, making it possible---even
likely---that at least one leader-dyad in a given year is credited with an alliance that was not active in the particular
leader-dyad. The Correlates of War's alliance data are not communicated with time measurements more granular than
the year. Apply these data to leader-level analyses with that in mind.
}
\examples{

# just call `library(tidyverse)` at the top of the your script
library(magrittr)

cow_ddy \%>\% add_cow_alliance()

}
\references{
Gibler, Douglas M. 2009. \emph{International Military Alliances, 1648-2008}. Congressional Quarterly Press.
}
\author{
Steven V. Miller
}
