% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/personograph.R
\name{personograph}
\alias{personograph}
\title{Plots a personograph}
\usage{
personograph(data, fig.title = NULL, fig.cap = NULL, draw.legend = T,
  icon = NULL, icon.dim = NULL, icon.style = 1, n.icons = 100,
  plot.width = 0.75, dimensions = ceiling(sqrt(c(n.icons, n.icons))),
  fudge = 0.0075, legend.show.zeros = TRUE, force.fill = "ignore",
  round.fn = round.standard, colors = as.colors(data))
}
\arguments{
\item{data}{A list of names to percentages (from 0 to 1)}

\item{fig.title}{Figure title}

\item{fig.cap}{Figure caption}

\item{draw.legend}{Logical if TRUE (default) will draw the legend}

\item{icon}{A \code{grImport} \code{Picture} for the icon, overwrites \code{icon.style}}

\item{icon.dim}{The dimensions of icon as a vector \code{c(width, height)} as numerical. Calculated from the \code{dimensions} if not supplied}

\item{icon.style}{A numeric from 1-11 indicating which of the included icons to use, they are mostly variations on the theme}

\item{n.icons}{Number of icons to draw, defaults to 100}

\item{plot.width}{The percentage of width that the main plotting area should take (with respect to the frame)}

\item{dimensions}{A vector of \code{c(rows, columns)} for the dimensions of the grid}

\item{fudge}{Fudge factor for the icon size, substracted from the \code{icon.size}}

\item{legend.show.zeros}{Logical if TRUE indicating whether to show zero (0) values in the legend.}

\item{force.fill}{A character vector of 'ignore' (default), 'most', 'least', or one of the names from \code{data}.
Defines the behaviour for cases when the rounding doesn't add
up to \code{n.icons}. 'ignore' simply draws less icons, 'most' adds an
icon to the largest group, 'least' to the smallest.
If a name from \code{data} is supplied it will added to that element}

\item{round.fn}{Function that is applied to round the percentages from \code{data} to \code{n.icons}. See also \code{force.fill}}

\item{colors}{A vector of names to colors, must match the names in data. Uses \code{gray.colors} style if none supplied}
}
\value{
None.
}
\description{
Plots a personograph from a named list with percentages (must sum to
1). A personograph is a graphical represenation of relative benefit
or harm, using a grid of icons with different colors. Its intended
use is similar to that of Cates Plots (Visual Rx, Number Needed to
Treat visualization).
Although these could be seen as Kuiper-Marshall plots.
}
\details{
\subsection{Supplying your own icon}{
You can supply your own icon by setting \code{icon} to a \code{grImport} \code{Picture}.
A \code{Picture} can be loaded with \code{grImport::readPicture} which requires a \code{grImport} XML file.
Obtaining this file from a standard SVG or PDF graphics file requires conversion.
The easiest way is to convert your original file to PDF and then to PostScript (PS) with the command-line \code{pdf2ps} tool, then tracing it with \code{grImport::PostScriptTrace}.
See the \code{grImport} package documentation for more details.}
}
\examples{
data <- list(first=0.9, second=0.1)
personograph(data)
# With colors
personograph(data, colors=list(first="red", second="blue"))
# With different icon.style
personograph(data, icon.style=4) # numeric from 1-11
# Plot a thousand in a 20x50 grid
personograph(data, n.icons=1000, dimensions=c(20,50), plot.width=0.75)
}

