% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools2.R
\name{createTRIGGER}
\alias{createTRIGGER}
\title{Generate a postgreSQL CREATE TRIGGER statement, optionally execute the statement if con is not NULL.}
\usage{
createTRIGGER(name, when, event, on, for_each_row = FALSE, func, con = NULL)
}
\arguments{
\item{name}{A string, the "name" parameter for postgreSQL CREATE TRIGGER.}

\item{when}{A string, the "when" parameter (BEFORE, AFTER, INSTEAD OF) for postgreSQL CREATE TRIGGER.}

\item{event}{A string, the "event" parameter (INSERT/UPDATE/DELETE/TRUNCATE) for postgreSQL CREATE TRIGGER.}

\item{on}{A string, the "table_name" parameter for postgreSQL CREATE TRIGGER.}

\item{for_each_row}{TRUE/FALSE, if TRUE, adds "FOR EACH ROW" to postgreSQL CREATE TRIGGER statement.}

\item{func}{A string, the function call to be executed by the postgreSQL CREATE TRIGGER.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, postgreSQL CREATE TRIGGER statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a postgreSQL CREATE TRIGGER statement, optionally execute the statement if con is not NULL.
}
\examples{
createTRIGGER(
name = "sample_trigger",
when = "AFTER",
event = "INSERT",
on = "sample_table",
for_each_row = TRUE,
func = "function_sample()"
)
}
