% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{transform_etas_tdist}
\alias{transform_etas_tdist}
\title{transform_etas_tdist}
\usage{
transform_etas_tdist(model, list_of_etas = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model to apply t distribution transformation to.}

\item{list_of_etas}{(str, vector) Name/names of etas to transform. If NULL, all etas will be transformed (default).}
}
\value{
(Model) Reference to the same model
}
\description{
Applies a t-distribution transformation to selected etas

Initial estimate for degrees of freedom is 80 with bounds (3, 100).
}
\examples{
\dontrun{
model <- load_example_model("pheno")
transform_etas_tdist(model, c("ETA(1)"))
model$statements$full_expression_from_odes("CL")
}
}
\seealso{
transform_etas_boxcox

transform_etas_john_draper
}
