% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pfr-P-ratio.r
\name{Pfr_P_ratio}
\alias{Pfr_P_ratio}
\title{Calculation of Pfr:Ptot ratio from spectral irradiance}
\usage{
Pfr_P_ratio(w.length, s.irrad = rep(1, length(w.length)),
  unit.in = "energy", check.spectrum = TRUE, use.cached.mult = FALSE)
}
\arguments{
\item{w.length}{numeric array of wavelength (nm)}

\item{s.irrad}{numeric array of spectral (energy) irradiances (W m-2 nm-1) or
(mol s-1 m-2)}

\item{unit.in}{character string with allowed values "energy", and "photon",
or its alias "quantum"}

\item{check.spectrum}{logical indicating whether to sanity check input data,
default is TRUE}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}
}
\value{
a single numeric value giving the unitless photon ratio
}
\description{
Ratio between  Pr and Ptot (photoequilibrium) for Type I Phytochrome.
}
\references{
Mancinelli, A.L. (1994) The physiology of phytochrome action. In
Photomorphogenesis in plants, 2nd edition. R.E. Kendrick and G.H.M.
Kronenberg, eds. Kluwer Academic Publishers, Dordrecht, pp. 211-269. ISBN
978-0-7923-2551-2 (print), 978-94-011-1884-2 (on-line).
\href{http://dx.doi.org/10.1007/978-94-011-1884-2_10}{DOI
10.1007/978-94-011-1884-2_10}
}
\keyword{internal}
