% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airway.R
\name{ett_size_by_age}
\alias{ett_size_by_age}
\title{Estimate appropriate size of endotracheal tube for infants and children}
\usage{
ett_size_by_age(age_y, cuffed = TRUE)
}
\arguments{
\item{age_y}{numeric vector}

\item{cuffed}{logical vector, single value, or a vector of the same length as
the given age vector, defining whether the desired tube is to be cuffed. If
not specified, then it is assumed that a cuffed tube is used.}
}
\value{
ETT size, internal diameter in mm, rounded to nearest half-mm size up
  to 6mm, then the nearest integer.
}
\description{
\code{ett_size_cole} uses the classic Cole formula for uncuffed tubes,
Motoyama formula for cuffed tubes with age over two years, and the Khine
formula for cuffed tubes with age under two years. All of these, as any
anesthesiologist will tell, give poor estimates at any extreme of age, or
height. These formulae are for use in pediatric practice only.
}
\examples{
teenagers <- ett_size_by_age(13:18)
plot(13:18, teenagers,
  main = "This formula for ETT tube size overestimates tube
  sizes of teenagers, and takes no account of gender")
lines(13:18, teenagers)
ages <- c(1/12, 1, 2, 4, 7, 11)
neonate_to_child <- ett_size_by_age(age = ages)
names(neonate_to_child) <- ages
print(neonate_to_child)
plot(ages, neonate_to_child)
lines(ages, neonate_to_child)
plot(ages, neonate_to_child, log = "x")
lines(ages, neonate_to_child)
}
\references{
\url{http://anesthesiology.pubs.asahq.org/Article.aspx?articleid=1933172}
}
\seealso{
Other airway equipment: \code{\link{deadspace_things_ml}},
  \code{\link{deadspace_total}}, \code{\link{ett_vol_ml}}
}
\concept{airway equipment}
