% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showOddsDF.R
\name{showOddsDF}
\alias{showOddsDF}
\title{showOddsDF - Takes a GetOdds JSON response and combines with Fixtures and Inrunning}
\usage{
showOddsDF(sportid, leagueids = NULL, since = NULL, islive = 0,
  force = TRUE, tableformat = "mainlines", namesLength = 3,
  attachLeagueInfo = TRUE, oddsformat = "AMERICAN", fixtures_since = NULL)
}
\arguments{
\item{sportid}{(optional) The sportid to get odds from, if none is given, 
a list of options and a prompt are provided}

\item{leagueids}{numeric vector of leagueids - can get as output from GetLeagues}

\item{since}{numeric This is used to receive incremental updates. this will give all lines that have changed odds.}

\item{islive}{boolean if TRUE retrieves ONLY live events}

\item{force}{boolean default set to TRUE, forces a reload of the cache.}

\item{tableformat}{\itemize{
\item 'mainlines' (default), only shows mainlines
\item 'long' for a single record for each spread/total on an event, 
\item 'wide' for all lines as one record, 
\item 'subtables' all lines for spreads/totals stored as nested tables
}}

\item{namesLength}{how many identifiers to use in the names, default is 3}

\item{attachLeagueInfo}{whether or not to include league information in the data}

\item{oddsformat}{default AMERICAN, see API manual for more options
bettable leagues}

\item{fixtures_since}{if set, get only fixtures that were posted since last.}
}
\value{
a dataframe combining GetOdds and GetFixtures data, containing NA's where levels of factors do not have a value.
Naming convention is as follows, Example: spread.altLineId.N is the altLineId associated with spread.hdp.(N+1) 
whereas spread.hdp refers to the mainline. spread.altLineId is the first alternate, and equivalent to spread.altLineId.0
}
\description{
showOddsDF - Takes a GetOdds JSON response and combines with Fixtures and Inrunning
}
\examples{
\donttest{
SetCredentials("TESTAPI","APITEST")
AcceptTermsAndConditions(accepted=TRUE)
# Run without arguments, it will prompt you for the sport
showOddsDF()}
}
