% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m325dropt.R
\name{m325dropt}
\alias{m325dropt}
\title{Minenergo-325. Temperature drop in pipe due heat losses}
\usage{
m325dropt(
  temperature = 130,
  pressure = mpa_kgf(6),
  consumption = 250,
  d = 700,
  len = 1,
  year = 1986,
  insulation = 0,
  laying = "underground",
  beta = FALSE,
  exp5k = TRUE
)
}
\arguments{
\item{temperature}{temperature of heat carrier (water) inside the pipe measured at the
entrance of pipe, [\emph{°C}]. Type: \code{\link{assert_double}}.}

\item{pressure}{\href{https://en.wikipedia.org/wiki/Pressure_measurement#Absolute}{absolute pressure}
of heat carrier (water) inside the pipe, [\emph{MPa}]. Type: \code{\link{assert_double}}.}

\item{consumption}{amount of heat carrier (water) that is transferred by pipe during a period,
[\emph{ton/hour}]. Type: \code{\link{assert_double}}.}

\item{d}{internal diameter of pipe, [\emph{mm}]. Type: \code{\link{assert_double}}.}

\item{len}{length of pipe, [\emph{m}]. Type: \code{\link{assert_double}}.}

\item{year}{year when the pipe is put in operation after laying or total overhaul.
Type: \code{\link{assert_integerish}}.}

\item{insulation}{insulation that covers the exterior of pipe:
\describe{
  \item{\code{0}}{no insulation}
  \item{\code{1}}{foamed polyurethane or analogue}
  \item{\code{2}}{polymer concrete}
}
Type: \code{\link{assert_subset}}.}

\item{laying}{type of pipe laying depicting the position of pipe in space:
\itemize{
  \item \code{air},
  \item \code{channel},
  \item \code{room},
  \item \code{tunnel},
  \item \code{underground}.
}
Type: \code{\link{assert_subset}}.}

\item{beta}{should they consider additional heat losses of fittings?
Type: \code{\link{assert_logical}}.}

\item{exp5k}{pipe regime flag: is pipe operated more that 5000 hours per year?
Type: \code{\link{assert_logical}}.}
}
\value{
\emph{normative temperature drop} at the outlet of pipe, [\emph{°C}].
 Type: \code{\link{assert_double}}.
}
\description{
Calculate temperature drop in steel pipe of \emph{district heating system}
 (where water is a heat carrier) that is a result of heat losses through
 pipe wall and insulation using
 \href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325} as a
 basis for values of heating flux.

 Since \href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325} is
 used as the basis for values of heating flux the calculated temperature
 drop may be considered as a \emph{normative temperature drop}. If the actual
 (somehow measured) temperature drop is more than this
 \emph{normative temperature drop} they may consider such difference to be
 due to \emph{extra-normative heat losses}. The presence of the latter
 requires appropriate maintenance activities.
}
\details{
The function is a simple wrapper for call of \code{\link{dropt}}
 with parameter \code{flux} calculated by \code{\link{m325nhl}}.
}
\examples{
 stopifnot(
   round(
     m325dropt(
       temperature = 130, year = 1968, laying = "channel", d = 700, l = 1000
     ), 2) == 1.37
 )
}
\seealso{
\code{\link{dropt}} for calculating temperature drop in pipe using
 actual heat flux values

Other Minenergo: 
\code{\link{m278hlair}()},
\code{\link{m278hlcha}()},
\code{\link{m278hlund}()},
\code{\link{m278insdata}},
\code{\link{m278inshcm}()},
\code{\link{m278soildata}},
\code{\link{m325beta}()},
\code{\link{m325nhldata}},
\code{\link{m325nhl}()},
\code{\link{m325testbench}}
}
\concept{Minenergo}
