% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textgif.R
\name{textgif}
\alias{textgif}
\title{Simple Text ".gif" File}
\usage{
textgif(
  text,
  text_color = NULL,
  bg_color = NULL,
  reflow = FALSE,
  width = 200,
  height = 100,
  family = "SimHei",
  fontface = 1,
  fps = 2,
  output = NULL,
  ...
)
}
\arguments{
\item{text}{must be a character vector.}

\item{text_color}{colors of the texts. Its 
length must be the same as that of 
\code{text}.}

\item{bg_color}{background color 
of the texts. It should have the same 
length as \code{text}.}

\item{reflow}{default is FALSE. If it is 
TRUE, \code{ggfittext::geom_fit_text} will 
automatically separate characters into 
several lines. However, you can separate 
lines manually by using line 
break.}

\item{width}{the width of the 
final gif object. Default is 200.
NOTE: how texts are adjusted in the text box 
depends on the values of width and height.}

\item{height}{the height of the 
final gif object. Default is 100.}

\item{family}{default is "SimHei" so that 
Chinese characters can be shown. However, 
some computers may not be able to use this 
family. And, this family ignores fontface.
For Latin words, the built-in families 
are "serif", "sans" and "mono", and more can 
be found by typing "?Hershey".}

\item{fontface}{1 (default) for plain, 
2 for bold, 3 for italic, 4 for bold italic.}

\item{fps}{the larger the faster. It should 
be a factor of 100, say, 2 (default), 4, 5, 10, 
rather than 3, 6, 7.}

\item{output}{if it is NULL (default), 
an object is created. Otherwise, object will not 
only be created but also be saved with a 
file name (".gif") represented by this argument.}

\item{...}{extra arguments used by 
\code{ggfittext::geom_fit_text}, 
e. g., angle (0 to 360), lineheight.}
}
\description{
This is a wrapper of functions in package
ggfittext and magick. The output is 
a ".gif" with changing texts and colors.
Characters are automatically enlarged or 
shrunk.
}
\examples{
\donttest{
mytext=c("AAA", "BBB", "CCC")
color1=c("orange", "red", "white")
color2=c("black", "blue", "green")
g1=textgif(mytext, text_color=color1, bg_color=color2, 
	width=180, height=120, fps=2, family="serif")
}
}
