% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmlb.R
\name{fetch_data}
\alias{fetch_data}
\title{fetch_data function}
\usage{
fetch_data(
  dataset_name,
  return_X_y = FALSE,
  local_cache_dir = NA,
  dropna = TRUE
)
}
\arguments{
\item{dataset_name}{The name of the data set to load from PMLB}

\item{return_X_y}{Boolean. Whether to return the data with the features and labels stored
in separate data structures or a single structure (can be TRUE or FALSE, defaults to FALSE)}

\item{local_cache_dir}{The directory on your local machine to store the data files in
(defaults to NA, indicating cache will not be used)}

\item{dropna}{Boolean. Whether rows with NAs should be automatically dropped. Default to TRUE.}
}
\description{
Download a data set from the PMLB repository, (optionally) store it locally, and return the data set.
You must be connected to the internet if you are fetching a data set that is not cached locally.
}
\examples{
 # Features and labels in single data frame
 penguins <- fetch_data('penguins')
 penguins

 # Features and labels stored in separate data structures
 penguins <- fetch_data('penguins', return_X_y=TRUE)
 penguins$x # data frame
 penguins$y # vector

}
\seealso{
\code{\link{summary_stats}}.
}
