% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqC.r
\name{freqC}
\alias{freqC}
\title{Generates table and figure describing distribution of variable values.}
\usage{
freqC(x, w, plot = TRUE)
}
\arguments{
\item{x}{A vector of variable values, should be in form dataset$var}

\item{w}{Sample weights (optional), should be in form dataset$weighvar}

\item{plot}{Do you want a bar chart? (default set to TRUE)}
}
\value{
A frequency distribution table (a "freqtable" and "matrix" class object)
}
\description{
Generates frequency distribution table and bar chart to describe distribution of variable values. Based on \code{\link[descr]{freq}} function in descr package.
}
\examples{
   library(poliscidata)
   
   freqC(gss$zodiac, gss$wtss)
   
   freqC(x=gss$zodiac, w=gss$wtss)
}
