% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poolcost_t.R
\name{poolcost_t}
\alias{poolcost_t}
\title{Visualize Total Costs for Pooling Design as a Function of Pool Size}
\usage{
poolcost_t(g = 1:10, d = NULL, mu1 = NULL, mu2 = NULL,
  sigsq = NULL, sigsq1 = sigsq, sigsq2 = sigsq, sigsq_p = 0,
  sigsq_m = 0, multiplicative = FALSE, alpha = 0.05, beta = 0.2,
  assay_cost = 100, other_costs = 0, labels = TRUE, ylim = NULL)
}
\arguments{
\item{g}{Numeric vector of pool sizes to include.}

\item{d}{Numeric value specifying true difference in group means.}

\item{mu1, mu2}{Numeric value specifying group means. Required if
\code{multiplicative = TRUE}.}

\item{sigsq}{Numeric value specifying the variance of observations.}

\item{sigsq1, sigsq2}{Numeric value specifying the variance of observations
for each group.}

\item{sigsq_p}{Numeric value specifying the variance of processing errors.}

\item{sigsq_m}{Numeric value specifying the variance of measurement errors.}

\item{multiplicative}{Logical value for whether to assume multiplicative
rather than additive errors.}

\item{alpha}{Numeric value specifying type-1 error rate.}

\item{beta}{Numeric value specifying type-2 error rate.}

\item{assay_cost}{Numeric value specifying cost of each assay.}

\item{other_costs}{Numeric value specifying other per-subject costs.}

\item{labels}{Logical value.}

\item{ylim}{Numeric vector.}
}
\value{
Plot of total costs vs. pool size generated by
\code{\link[ggplot2]{ggplot}}.
}
\description{
Useful for determining whether pooling is a good idea, what pool size
minimizes costs, and how many assays are needed for a target power.
}
\examples{
# Plot total study costs vs. pool size for d = 0.25, sigsq = 1, and costs of
# $100 per assay and $0 in other per-subject costs.
poolcost_t(d = 0.25, sigsq = 1)

# Repeat but with additive processing error and $10 in per-subject costs.
poolcost_t(d = 0.25, sigsq = 1, sigsq_p = 0.5, other_costs = 10)


}
