% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omit_std.R
\name{omit_std.powdRafps}
\alias{omit_std.powdRafps}
\title{Omit the internal standard from phase concentration data within a \code{powdRafps} object}
\usage{
\method{omit_std}{powdRafps}(x, ...)
}
\arguments{
\item{x}{A \code{powdRafps} object derived from \code{afps()}.}

\item{...}{other arguments}
}
\value{
a \code{powdRafps} object with components:
\item{tth}{a vector of the 2theta scale of the fitted data}
\item{fitted}{a vector of the fitted XRPD pattern}
\item{measured}{a vector of the original XRPD measurement (aligned and harmonised)}
\item{residuals}{a vector of the residuals (measured minus fitted)}
\item{phases}{a dataframe of the phases used to produce the fitted pattern and their concentrations}
\item{phases_grouped}{the phases dataframe grouped by phase_name and concentrations summed}
\item{obj}{named vector of the objective parameters summarising the quality of the fit}
\item{weighted_pure_patterns}{a dataframe of reference patterns used to produce the fitted pattern.
All patterns have been weighted according to the coefficients used in the fit}
\item{coefficients}{a named vector of coefficients used to produce the fitted pattern}
\item{inputs}{a list of input arguments used in the function call}
}
\description{
\code{omit_std.powdRafps} adjusts phase concentrations in a \code{powdRafps} object by removing
the concentrations of the internal standard. Relevant information for the calculation is
automatically extracted from \code{x$inputs$std} and \code{x$inputs$std_conc}.
}
\examples{
\dontrun{
data(rockjock)
data(rockjock_mixtures)

rockjock_a1 <- afps(lib = rockjock,
                    smpl = rockjock_mixtures$Mix1,
                    std = "CORUNDUM",
                    align = 0.3,
                    lod = 1,
                    std_conc = 20)

rockjock_a1o <- omit_std(rockjock_a1)

}
}
