% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcp.r
\name{pcp}
\alias{pcp}
\title{Precipitation Concentration Period}
\usage{
pcp(object)
}
\arguments{
\item{object}{a daily or monthly precipitation serie.}
}
\value{
A data.frame containing the following variables:
\itemize{
\item \code{year} is the year.
\item \code{pcp} is the precipitation concentration period, in degree, corresponding to a year.
Results correspond to a month like below when using the `azimuth`  default values:
0 = January, 30 = February, 60 = March, \dots, 300 = November, and 330 = December.
}
}
\description{
Calculates the Precipitation Concentration Period (PCP) on a 
daily or monthly precipitation serie.
}
\examples{
##
# Loading the monthly precipitation serie.
data(monthly)

## 
# Performing the Precipitation Concentration Degree analysis
pcd(monthly)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\references{
Zhang L.J., Qian Y.F. (2003) Annual distribution features of precipitation in China and their interannual variations. J Acta Meteorological Sinica 17:146-163
}
\seealso{
\code{\link{pplot.pcp}}
\code{\link{read.data}}
\code{\link{as.daily}}
\code{\link{as.monthly}}
}
\keyword{PCD}
\keyword{concentration}
\keyword{degree}
\keyword{precipitation}

