% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_predict.R
\name{predictionMetrics}
\alias{predictionMetrics}
\title{Measures of Prediction Performance}
\usage{
predictionMetrics(centers, cluster.pred, X, labels = TRUE)
}
\arguments{
\item{centers}{Matrix of Cluster centers}

\item{cluster.pred}{Vector of predicted cluster membership. Should be integers
or names corresponding to rows of \code{centers}.}

\item{X}{Matrix of observations at prediction locations.}

\item{labels}{Logical indicating whether cluster prediction and}
}
\value{
A list with the following elements:
\item{MSPE}{Mean squared prediction error. Sum of squared distances between observations and predicted cluster centers.}
\item{wSS}{Within-cluster sum-of-squares.  Sum of squared distances between observations at prediction locations and best (i.e. closest) cluster center.}
\item{MSME}{Mean squared misclassification error.  Sum of squared distances between predicted cluster center and best (i.e. closest) cluster center.}
\item{pred.acc}{Proportion of cluster labels correctly predicted.}
\item{cluster.pred}{Predicted cluster assignments (same as argument provided).}
\item{cluster.assign}{Integer vector of 'best' cluster assignments (i.e. assignment to closest cluster center)}
}
\description{
Computes several measures of performance for cluster label prediction.
}
\examples{
n <- 100
d <- 5 # Dimension of exposure
K <- 3 # Number of clusters
X <- matrix(rnorm(n*d), ncol=d, nrow=n)
centers <- matrix(runif(d*K), nrow=K, ncol=d)
cluster_pred <- sample(1:K, size=n, replace=TRUE)
metrics <- predictionMetrics(centers, cluster.pred=cluster_pred, X=X)
metrics[c("MSPE", "wSS", "MSME", "pred.acc")]
}
\references{
Keller, J.P., Drton, M., Larson, T., Kaufman, J.D., Sandler, D.P., and Szpiro, A.A. (2017). Covariate-adaptive clustering of exposures for air pollution epidemiology cohorts. \emph{Annals of Applied Statistics}, 11(1):93--113.
}
\seealso{
\code{\link{predictML}}
}
\author{
Joshua Keller
}
