% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.pstp.R
\name{summary.pstp}
\alias{summary.pstp}
\title{Summarizing fits of "pstp" class}
\usage{
\method{summary}{pstp}(object, state_ini = 0, times = NULL, ...)
}
\arguments{
\item{object}{A fitted pstp object as produced by presmTP.}

\item{state_ini}{Initial state of the transition. Defaults to state_ini=0.}

\item{times}{Vector of times; the returned data frame will contain 1 row for each time.}

\item{...}{For future methods.}
}
\value{
A data frame or a list containing the estimates of the probability.
}
\description{
Returns a a data.frame or list containing the estimates of the probabilities.
}
\examples{
res<- presmTP(data = colonIDM, s = 365, method = "uns")
summary(res, state_ini=1, times=365*1:5)
}
\author{
Gustavo Soutinho, Luis Meira-Machado, Pedro Oliveira.
}
