% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/511.Error-Failure_LimitBased_ADJ_All.R
\name{errATW}
\alias{errATW}
\title{Calculates error, long term power and pass/fail criteria for adjusted Wald-T method}
\usage{
errATW(n, alp, h, phi, f)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- Adding factor}

\item{phi}{- Null hypothesis value}

\item{f}{- Failure criterion}
}
\value{
A dataframe with
 \item{delalp}{ Delta-alpha is the increase of the nominal error with respect to real error}
 \item{theta}{ Long term power of the test}
 \item{Fail_Pass}{Fail/pass based on the input f criterion}
}
\description{
Calculates error, long term power and pass/fail criteria for adjusted Wald-T method
}
\details{
Evaluation of approximate and adjusted method based on a
t_approximation of the standardized point estimator
using error due to the difference of achieved and nominal level of significance for the \eqn{n + 1} intervals
}
\examples{
n=20; alp=0.05; h=2;phi=0.99; f=-2
errATW(n,alp,h,phi,f)
}
\references{
[1] 2014 Martin Andres, A. and Alvarez Hernandez, M.
Two-tailed asymptotic inferences for a proportion.
Journal of Applied Statistics, 41, 7, 1516-1529
}
\seealso{
Other Error for adjusted methods: \code{\link{PloterrAAS}},
  \code{\link{PloterrAAll}}, \code{\link{PloterrALR}},
  \code{\link{PloterrALT}}, \code{\link{PloterrASC}},
  \code{\link{PloterrATW}}, \code{\link{PloterrAWD}},
  \code{\link{errAAS}}, \code{\link{errAAll}},
  \code{\link{errALR}}, \code{\link{errALT}},
  \code{\link{errASC}}, \code{\link{errAWD}}
}
