% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psd-package.R
\docType{data}
\name{Tohoku}
\alias{Tohoku}
\title{Observations of teleseismic strains from the 2011 Tohoku earthquake.}
\format{
A dataframe with 16000 observations on the following 15 variables.

\describe{
\item{\code{Dts}}{The original datetime string, in UTC.}
\item{\code{areal}}{Areal strains}
\item{\code{areal.tide}}{Tidal correction to the areal strains.}
\item{\code{areal.baro}}{Barometric correction to the areal strains.}
\item{\code{gamma1}}{Engineering differential extensional strain: \eqn{\gamma_1}}
\item{\code{gamma1.tide}}{Tidal correction for the \eqn{\gamma_1} strains.}
\item{\code{gamma1.baro}}{Barometric pressure correction to the \eqn{\gamma_1} strains.}
\item{\code{gamma2}}{Engineering shear strain: \eqn{\gamma_2}}.
\item{\code{gamma2.tide}}{Tidal correction for the \eqn{\gamma_2} strains.}
\item{\code{gamma2.baro}}{Barometric pressure correction to the \eqn{\gamma_2} strains.}
\item{\code{pressure.atm}}{Atmospheric pressure.}
\item{\code{pressure.pore}}{Pore-fluid pressure.}
\item{\code{Dt}}{The \code{Dts} information converted to POSIX datetime.}
\item{\code{Origin.secs}}{The number of seconds relative to the earthquake-origin time.}
\item{\code{epoch}}{Classification based on predicted P-wave arrival: preseismic or seismic.}
}

and 2 attributes:

\describe{
\item{\code{units}}{A list of strings regarding the units of various physical quantities given here.}
\item{\code{iasp}}{A list of source and station characteristics, including the
the origin time, predicted
traveltimes for P and S waves, and the geodetic information used in the traveltime
calculation.}
}
}
\source{
High frequency strain data archive:

\url{http://borehole.unavco.org/bsm/earthquakes/NeartheEastCoastofHonshuJapan_20110311/}
}
\description{
The \eqn{M_w 9} Tohoku earthquake happened on March 11, 2011.  The seismic
waves were recorded at stations across the globe, including by borehole strainmeters
in the Network of the Americas (NOTA), which was previously
known as the Plate Boundary Observatory (PBO) network.
}
\details{
These data are for station B084, which is located approximately 8500 km away from
the epicenter. Because this distance is large, the seismic waves didn't arrive
at this station for more than 700 seconds after the origin time.  So there
is a record of pre-seismic noise included, the timeseries extends 6784 seconds
prior to the origin time, and 9215 seconds after.  

The data are classified with the \code{"epoch"} variable, which separates
the series into pre-seismic and seismic data; this is defined relative
to the predicted P-wave arrival time from a traveltime model.

The original dataset contained \code{NA} values, which were imputed
using \code{zoo::na.locf}, which fills \code{NA} with the last previous observation.
}
\examples{
data(Tohoku)
str(Tohoku)
}
\references{
USGS summary page:

\url{https://earthquake.usgs.gov/earthquakes/eventpage/official20110311054624120_30/executive}
}
\seealso{
\code{\link{pspectrum}}, \code{\link{hfsnm}}, \code{\link{magnet}}

\code{TauP.R} for an R-implementation of the traveltime calculations
}
\keyword{datasets}
