% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalar.R
\name{pspline.estimate.scalars}
\alias{pspline.estimate.scalars}
\title{Calculates confidence intervals for scalars estimated from generalized additive (mixed) model of an outbreak}
\usage{
pspline.estimate.scalars(
  model,
  predictors,
  outcomes,
  samples = 100,
  level = 0.95
)
}
\arguments{
\item{model}{model returned by \code{\link[mgcv]{gam}} or \code{\link[mgcv]{gamm}}}

\item{predictors}{data.frame of predictor values at which the model will be evaluated}

\item{outcomes}{function returning calculated scalar outcomes, as described above}

\item{samples}{number of samples of outcomes to draw}

\item{level}{confidence level for estimates}
}
\value{
data frame of estimates, as described above
}
\description{
This function performs Monte Carlo sampling of a GAM/GAMM outbreak model.
For each sampled curve, it calls \code{outcomess} to calculate scalar outcomes
It then calculates and returns the confidence interval of each scalar outcome
}
\details{
The \code{outcomes} function must accept (\code{model}, \code{params}, \code{predictors}) and return a one-row data frame
in which each column lists the value of a single scalar outcome calculated from the model
estimates.

A typical implementation of the \code{outcomes} function would call \code{predict} on
\code{model} and \code{predictors} to obtain model variable estimates at predictor values, then
calculate the scalar outcomes of interest and return them in a data frame.

For example, to calculate the time of outbreak peak, you might use this function for \code{outcomes}:

\code{
calc_peak = function(model, params, time) {
  incidence = predict(model, data.frame(time=time), type="response")
  data.frame(peak=time[which.max(incidence)])
}
}

The data frame returned by \code{pspline.estimate.scalars} contains three columns for each
outcome calculated by \code{outcomes}: for outcome \code{x} returned by \code{outcomes},
\code{pspline.estimate.scalars} returns columns \code{x.lower}, \code{x.median}, and \code{x.upper}, corresponding
to lower confidence limit, median, and upper confidence limit of \code{x}.
}
