% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipysd.R
\name{read_xmile}
\alias{read_xmile}
\title{Loads a XMILE simulation file (.xmile)}
\usage{
read_xmile(o, file)
}
\arguments{
\item{o}{is the ipysd S3 object}

\item{file}{is the filename and path for the Vensim mdl file that needs to be simulated}
}
\value{
An S3 object of class ipysd that will contain a reference to the model
}
\description{
\code{read_xmile()} calls \code{pysd.read_xmile()} and stores the object for
further use. This is a key object, as it relates to a model and it can
support a number of functions (e.g. model run, parameter changes)
}
\details{
The result is used as a parameter for simulation calls.

As it's a generic function, this call is dispatched to read_xmile.isdpy
}
\examples{
\dontrun{
target <- system.file("models/xmile", "Population.xmile", package = "pysd2r")
py <- pysd_connect()
read_xmile(py, target)
}
}
