% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xrs.R
\name{xrs}
\alias{xrs}
\alias{xrs.default}
\title{Xbar Control Charts Under Repetitive Sampling}
\usage{
xrs(.c, .n, .k1, .k2)

\method{xrs}{default}(.c, .n, .k1, .k2)
}
\arguments{
\item{.c}{Size of the Shift}

\item{.n}{Sample Size}

\item{.k1}{Positive Integer}

\item{.k2}{Positive Integer}
}
\value{
Average Sample Number (ASN) and Average Run Length (ARL1) for xbar control charts under repetitive sampling
}
\description{
Calculates the Average Sample Number and Average Run Length as given in Aslam et al. (2014)
}
\examples{

library(magrittr)
library(purrr)

c(0.0, 0.1, 0.20, 0.3, 0.4, 0.5, 1.0, 1.5, 2, 3) \%>\%
purrr::map(
function(x) 
    xrs(
        .c     = x
      , .n     = 10
      , .k1    = 2.9301
      , .k2    = 0.9825))

}
\references{
Aslam, M., Azam, M. and Jun, C. (2014).
 New Attributes and Variables Control Charts under Repetitive Sampling.
 \emph{Industrial Engineering & Management Systems}.
 \strong{1}(13):101-106.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Muhammad Aslam (\email{aslam_ravian@hotmail.com})
         \item Sami Ullah (\email{samiullahuos@gmail.com})
         \item Muhammad Azam   (\email{mazam@uvas.edu.pk})
         \item Chi-Hyuck Jun   (\email{chjun@postech.ac.kr})
         \item Muhammad Kashif (\email{mkashif@uaf.edu.pk})
         }
}
