% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_qtl.R
\name{modify_qtl}
\alias{modify_qtl}
\alias{print.qtlpoly.modify}
\title{Modify QTL model}
\usage{
modify_qtl(
  model,
  pheno.col = NULL,
  add.qtl = NULL,
  drop.qtl = NULL,
  verbose = TRUE
)

\method{print}{qtlpoly.modify}(x, pheno.col = NULL, ...)
}
\arguments{
\item{model}{an object of class \code{qtlpoly.model} containing the QTL to be modified.}

\item{pheno.col}{a phenotype column number whose model will be modified or printed.}

\item{add.qtl}{a marker position number to be added.}

\item{drop.qtl}{a marker position number to be removed.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.modify} to be printed.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.modify} which contains a list of \code{results} for each trait with the following components:

    \item{pheno.col}{a phenotype column number.}
    \item{stat}{a vector containing values from score statistics.}
    \item{pval}{a vector containing \emph{p}-values from score statistics.}
    \item{qtls}{a data frame with information from the mapped QTL.}
}
\description{
Adds or removes QTL manually from a given model.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Search for QTL
  remim.mod = remim(data = data, pheno.col = 1, w.size = 15, sig.fwd = 0.0011493379,
sig.bwd = 0.0002284465, d.sint = 1.5, n.clusters = 1)

  # Modify model
  modified.mod = modify_qtl(model = remim.mod, pheno.col = 1, drop.qtl = 18)
  }

}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
}
\seealso{
\code{\link[qtlpoly]{read_data}}, \code{\link[qtlpoly]{remim}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
