% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCurv.R
\name{bSplinesData}
\alias{bSplinesData}
\title{Centile curves using B-splines compared to noise data}
\usage{
bSplinesData(
  x,
  y,
  lambdas,
  data,
  cents = c(0.03, 0.25, 0.5, 0.75, 0.97),
  leg = FALSE
)
}
\arguments{
\item{x}{the explanatory variable - numeric}

\item{y}{the response variable - numeric}

\item{lambdas}{to be set by user. Can be a vector or a single numeric value. Tunes the tradeoff between the goodness of fit and the regularity of the spline - numeric value or numeric vector}

\item{data}{the noise data to be compared to}

\item{cents}{A numeric vector that represents the centiles calculated. Default is set to cents=c(0.03,0.25,0.5,0.75,0.97))}

\item{leg}{Boolean. Should the legend be desplayed (TRUE) or not (FALSE).}
}
\value{
Plots centile curves with B-splines of different differential orders (d) and displays them on the same figure as the noise data
}
\description{
Centile curves using B-splines compared to noise data
}
\examples{
#create a sample data frame
sample<-data.frame(sample(30:42,30,rep=TRUE),sample(800:5000,30,rep=TRUE))
colnames(sample)<-c("Gestational Age in weeks","Weight in gramms")
x<-sample$`Gestational Age in weeks`
y<-sample$`Weight in gramms`
abnormal<-data.frame(sample(30:42,6,rep=TRUE),sample(800:5000,6,rep=TRUE))
colnames(abnormal)<-c("Gestational Age in weeks","Weight in gramms")
bSplinesData(x,y,lambdas=1,abnormal)


}
