% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{reorders}
\alias{reorders}
\title{Reorder Levels of Factor Data}
\usage{
reorders(data, fct.nm, ord.nm = NULL, fun, ..., suffix = "_r")
}
\arguments{
\item{data}{data.frame of data.}

\item{fct.nm}{character vector of colnames in \code{data} that specify the
factor columns. If any of the columns specified by \code{fct.nm} are not
factors, then an error is returned.}

\item{ord.nm}{character vector of length 1 or \code{NULL}. If a character
vector of length 1, it is a colname in \code{data} specifying the column in
\code{data} that will be used in conjunction with \code{fun} to re-order
the factor columns. If \code{NULL} (default), it is assumed that each
factor column itself will be used in conjunction with \code{fun} to
re-order the factor columns.}

\item{fun}{function that will be used to re-order the factor columns. The
function is expected to input an atomic vector of length =
\code{nrow(data)} and return an atomic vector of length 1. \code{fun} is
applied to \code{data[[ord.nm]]} if \code{ord.nm} is a character vector of
length 1 or applied to each column in \code{data[fct.nm]} if \code{ord.nm}
= \code{NULL}.}

\item{...}{additional named arguments used by \code{fun}. For example, if
\code{fun} is \code{mean}, the user might specify an argument \code{na.rm =
TRUE} to set the \code{na.rm} argument in the \code{mean} function.}

\item{suffix}{character vector of length 1 specifying the string that will be
appended to the end of the colnames in the return object.}
}
\value{
data.frame of re-ordered factor columns with colnames =
  \code{paste0(fct.nm, suffix)}.
}
\description{
\code{reorders} re-orders the levels of factor data. The factors are columns
in a data.frame where the same reordering scheme is desired. This is often
useful before using factor data in a statistical analysis (e.g., \code{lm})
or a graph (e.g., \code{ggplot}). It is essentially a vectorized version of
\code{reorder.default}.
}
\examples{

# factor vector
reorder(x = state.region, X = state.region,
   FUN = length) # least frequent to most frequent
reorder(x = state.region, X = state.region,
   FUN = function(vec) {-1 * length(vec)}) # most frequent to least frequent

# data.frame of factors
infert_fct <- infert
fct_nm <- c("education","parity","induced","case","spontaneous")
infert_fct[fct_nm] <- lapply(X = infert[fct_nm], FUN = as.factor)
x <- reorders(data = infert_fct, fct.nm = fct_nm,
   fun = length) # least frequent to most frequent
lapply(X = x, FUN = levels)
y <- reorders(data = infert_fct, fct.nm = fct_nm,
   fun = function(vec) {-1 * length(vec)}) # most frequent to least frequent
lapply(X = y, FUN = levels)
# ord.nm specified as a different column in data.frame
z <- reorders(data = infert_fct, fct.nm = fct_nm, ord.nm = "pooled.stratum",
   fun = mean) # category with highest mean for pooled.stratum to
   # category with lowest mean for pooled.stratum
lapply(X = z, FUN = levels)

}
\seealso{
\code{\link[stats]{reorder.default}}
}
