% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{summary_table_042}
\alias{summary_table_042}
\alias{cbind.qwraps2_summary_table_042}
\alias{rbind.qwraps2_summary_table_042}
\alias{qsummary_042}
\alias{tab_summary}
\title{Deprecated functions}
\usage{
summary_table_042(x, summaries = qsummary_042(x))

\method{cbind}{qwraps2_summary_table_042}(..., deparse.level = 1)

\method{rbind}{qwraps2_summary_table_042}(..., deparse.level = 1)

qsummary_042(.data, numeric_summaries, n_perc_args, env)

tab_summary(
  x,
  n_perc_args = list(digits = 0, show_symbol = FALSE),
  envir = parent.frame()
)
}
\arguments{
\item{x}{a variable to summarize}

\item{summaries}{a list of lists of formulea for summarizing the data set.
See Details and examples.}

\item{...}{\code{qwraps2_summary_table_042} objects to bind together}

\item{deparse.level}{integer controlling the construction of labels in the
case of non-matrix-like arguments (for the default method): \code{deparse.level =
0} constructs no labels; the default, \code{deparse.level = 1} or
\code{deparse.level = 2} constructs labels from the argument names.}

\item{.data}{a \code{data.frame}}

\item{numeric_summaries}{a list of functions to use for summarizing numeric
variables.  The functions need to be provided as character strings with the
single argument defined by the \code{\%s} symbol.}

\item{n_perc_args}{a list of arguments to pass to \code{n_perc}}

\item{env}{environment to assign to the resulting formulae}

\item{envir}{the environment to attach to the resulting formulea}
}
\description{
Functions listed here are deprecated.  Replacement methods have been
developed to replace these methods.
}
\details{
\code{summary_table_042} and \code{qsummary_042} have been redesigned with some
changes to the api for version 0.5.0 of qwraps2.  The version released
up through version 0.4.2 have been placed here with the appended _042 on the
function names.  This will will for soft deprecation in 0.5.0 (warning), hard
deprecation in later (error), and eventual removal from the package.
}
\examples{

data(mtcars2)
st <- summary_table_042(mtcars2[, c("mpg", "wt", "cyl_factor")])
print(st, markup = "markdown")

# build the summaries quickly
qs <- qsummary_042(mtcars2)

summary_table_042(mtcars2, summaries = qs[c("mpg", "cyl", "wt", "gear_factor")])

# the _042 method would only allow for summary by a variable is
# dplyr::group_by was used.  The updated version for qwraps2 version 0.5.0
# has a improved api to summarize by a variable much easier.
st <- summary_table_042(dplyr::group_by(mtcars2, transmission),
                  summaries = qs[c("mpg", "wt", "cyl", "cyl_character", "cyl_factor")])
print(st, markup = "markdown")

}
\seealso{
\code{\link{qable}} for marking up \code{qwraps2_data_summary}
objects.  \code{\link[dplyr]{group_by}} for \code{\link[dplyr]{grouped_df}}
objects.  The \code{vignette("summary-statistics", package = "qwraps2")} for
detailed use of these functions and caveats.

\code{cbind}

\code{rbind}
}
