% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{summariseExperiment}
\alias{summariseExperiment}
\title{This function is a wrapper for getting a summary of the results of an rSHAPE run and/or experiment as a whole.  The
former is presumed to be of greater use but either is fine as per your needs.  This wrapper will cause
RData files to be created which contain the summarised experimental details that you can then use more easily
for analysis.}
\usage{
summariseExperiment(func_processingTypes = c("fileList", "parameters",
  "popDemographics", "repeatability"), func_numCores = 1,
  func_suppressOld = FALSE)
}
\arguments{
\item{func_processingTypes}{A vector of character strings which define the type of processing to be performed
when callign this experimental analysis wrapper function.  At present, the types include:
"fileList", "parameters", "popDemographics","repeatability" as per the rSHAPE option - shape_procExp_filenames}

\item{func_numCores}{Integer number of computer cores to be requested for performing parallel processing
of experiment files.  It defaults as 1, which effectively means in tandem - ie: not parallel.}

\item{func_suppressOld}{This is a logical toggle if files which exist in the expected location should be deleted.
Default is FALSE and the function will simply not process alraedy processed output.  TRUE might be useful as a means
to forcibly re-run the summary fresh.}
}
\value{
A message detailing if the requested processed files can be found, either affirmative for all
or a note when at least one is missing.
}
\description{
This function is a wrapper for getting a summary of the results of an rSHAPE run and/or experiment as a whole.  The
former is presumed to be of greater use but either is fine as per your needs.  This wrapper will cause
RData files to be created which contain the summarised experimental details that you can then use more easily
for analysis.
}
\section{Note}{

There is no example as this cannot work without a complete rSHAPE experiment to be analysed.
}

