% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulater.R
\name{repeater}
\alias{repeater}
\title{Repeated simulation}
\usage{
repeater(
  dataset,
  nr = 12,
  vars = "",
  grid = "",
  sum_vars = "",
  byvar = ".sim",
  fun = "sum",
  form = "",
  seed = NULL,
  name = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Return value from the simulater function}

\item{nr}{Number times to repeat the simulation}

\item{vars}{Variables to use in repeated simulation}

\item{grid}{Character vector of expressions to use in grid search for constants}

\item{sum_vars}{(Numeric) variables to summaries}

\item{byvar}{Variable(s) to group data by before summarizing}

\item{fun}{Functions to use for summarizing}

\item{form}{A character vector with the formula to apply to the summarized data}

\item{seed}{Seed for the repeated simulation}

\item{name}{Deprecated argument}

\item{envir}{Environment to extract data from}
}
\description{
Repeated simulation
}
\examples{
simdat <- simulater(
  const = c("var_cost 5","fixed_cost 1000"),
  norm = "E 0 100;",
  discrete = "price 6 8 .3 .7;",
  form = c(
    "demand = 1000 - 50*price + E",
    "profit = demand*(price-var_cost) - fixed_cost",
    "profit_small = profit < 100"
  ),
  seed = 1234
)

repdat <- repeater(
  simdat,
  nr = 12,
  vars = c("E","price"),
  sum_vars = "profit",
  byvar = ".sim",
  form = "profit_365 = profit_sum < 36500",
  seed = 1234,
)

head(repdat)
summary(repdat)
plot(repdat)

}
\seealso{
\code{\link{summary.repeater}} to summarize results from repeated simulation

\code{\link{plot.repeater}} to plot results from repeated simulation
}
