% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bidders.R
\name{Bidders}
\alias{Bidders}
\alias{gWealthStep}
\alias{makeStepwiseBidder}
\title{Making Bidder Objects}
\usage{
gWealthStep(wealth, alg, r, TSS, p, reuse, rmse, df)

makeStepwiseBidder(gWealth)
}
\arguments{
\item{wealth}{starting alpha-wealth.}

\item{alg}{algorithm can be one of "rai", "raiPlus", or "RH" (Revisiting
Holm).}

\item{r}{RAI rejects tests which increase R^2 by a factor r^s, where s is the
epoch.}

\item{TSS}{total sum of squares of the response.}

\item{p}{number of covariates (only used when alg == "RH").}

\item{reuse}{logical. Should repeated tests of the same covariate be
considered a test of the same hypothesis?}

\item{rmse}{initial (or independent) estimate of residual standard error}

\item{df}{degrees of freedom of rmse.}

\item{gWealth}{a global wealth object; output of gWealthStep.}
}
\value{
A closure containing a list of functions.
}
\description{
These functions create objects that manage alpha-wealth. There
  is only one stepwise "bidder" that manages the global wealth (gWealth) but
  it can have multiple "offspring" when searching for polynomials. The outer
  \code{\link{rai}} function creates one gWealthStep object and one stepwise
  bidder at the beginning. The stepwise bidder makes a local modification to
  gWealth, though bidAccepted/bidRejected still call gWealth. More stepwise
  bidders are created as "scavengers" tied to the global wealth. Defaults are
  not set because these are internal functions called by \code{\link{rai}}
  and \code{\link{runAuction}} and all arguments are required.
}
