% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/built_in_distributions.R
\name{r_beta}
\alias{r_beta}
\title{Generate Beta Distributed Values}
\usage{
r_beta(alpha, beta, ..., n = default_n(alpha, beta), .seed = NULL)
}
\arguments{
\item{alpha, beta}{vectors of shape parameters, strictly positive}

\item{...}{Unused}

\item{n}{number of observations to generate. The \code{\link[=default_n]{default_n()}} function will
provide a default value within context}

\item{.seed}{One of the following:
\itemize{
\item NULL (default) will not change the current seed. This is the
usual case for generating random numbers.
\item A numeric value. This will be used to set the seed before generating
the random numbers. This seed will be stored with the results.
\item TRUE. A random seed value will be generated and set as the seed
before the results are generated. Again, this will be stored with
the results.
}

To extract the random seed from a previously generated set of
values, use \code{pull_seed()}}
}
\value{
A numeric vector of length \code{n}
}
\description{
Generates a set of Beta distributed values.
}
\examples{

set_n(5)

r_beta(1, 1)

r_beta(1:10, 2)

r_beta(1, 2, n = 10)
}
