% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetUserPhone.R
\name{getUserPhone}
\alias{getUserPhone}
\title{Get user phone (number) from config or session object}
\usage{
getUserPhone(shinySession = NULL)
}
\arguments{
\item{shinySession}{Shiny session object (list, NULL by default). Must be
provided when the source of user attributes is either the shiny app url or
an external authentication provider. By default this will apply to the
'TEST', 'QA' and 'PRODUCTION' contexts in which case the shiny session
object must be provided.}
}
\value{
String phone number
}
\description{
This is a helper function for \code{\link{userInfo}}. When used without a
shiny session object calls to this function is made without any arguments. If
redefining contexts is needed, please use \code{\link{userInfo}} instead.
}
\examples{
\donttest{
# Requires a valid shiny session object
getUserPhone()
getUserPhone(shinySessionObject)
}

}
\seealso{
\code{\link{getUserName}},
\code{\link{getUserGroups}}, \code{\link{getUserReshId}},
\code{\link{getUserEmail}}, \code{\link{getUserFullName}}
}
