% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{rapidoc_spec}
\alias{rapidoc_spec}
\title{RapiDoc Index File with OpenAPI Path}
\usage{
rapidoc_spec(
  spec_url = "https://petstore.swagger.io/v2/swagger.json",
  fonts_css = "./fonts.css",
  slots = character(),
  ...
)
}
\arguments{
\item{spec_url}{Url to an openAPI specification}

\item{fonts_css}{Path to the fonts css file if you want to use fonts other than the default one.}

\item{slots}{HTML content to include between `<rapi-doc>` and `</rapi-doc>`}

\item{...}{Other options recognized by RapiDoc inside the `rapi-doc` tag. You can replace `-` by underscore in names.
See https://mrin9.github.io/RapiDoc/api.html for a list of available options.}
}
\value{
large string containing the contents of \code{\link{rapidoc_index}()} with
the appropriate speicification path changed to the \code{spec_url} value.
}
\description{
Produces the content for a \code{index.html} file that will attempt to access a
provided OpenAPI Specification URL.
}
\examples{
if (interactive()) {
  slot1 <- '
  <img slot="logo"
  src="https://upload.wikimedia.org/wikipedia/commons/5/53/Google_\%22G\%22_Logo.svg"
  width=36px/>'
  rapidoc_spec("https://petstore.swagger.io/v2/swagger.json",
               fonts_css = "./fonts.css",
               slots = c(slot1),
               heading_text = "Google",
               allow_server_selection = FALSE)
}
}
