% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_array.R
\name{interpolate_array}
\alias{interpolate_array}
\title{Matrix/Array Interpolation}
\usage{
interpolate_array(image, x, y)
}
\arguments{
\item{image}{Image filename, a matrix, or a 3-layer RGB array.}

\item{x}{X indices (or fractional index) to interpolate.}

\item{y}{Y indices (or fractional index) to interpolate.}
}
\value{
Either a vector of values (if image is a matrix) or a list of interpolated values
from each layer.
}
\description{
Given a series of X and Y coordinates and an array/matrix, interpolates the Z coordinate
using bilinear interpolation.
}
\examples{
if(interactive()){
#Interpolate a matrix
interpolate_array(volcano,c(10,10.1,11),c(30,30.5,33))
#Interpolate a 3-layer array (returns list for each channel)
interpolate_array(dragon,c(10,10.1,11),c(30,30.5,33))
}
}
