% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilFuncs.R
\name{intMinDay}
\alias{intMinDay}
\title{Integer representation of a day-begin}
\usage{
intMinDay(x)
}
\arguments{
\item{x}{\code{POSIXct}, date/time object.}
}
\value{
\code{integer}
}
\description{
This function returns the associated \code{integer} time
for the start of a specific day (\emph{i.e.}, \code{00:00:00} time).
}
\examples{
d1 <- "2017-03-15"
d1 <- intMinDay(d1)
d2 <- "2017-03-15 00:00:00"
d2 <- intMinDay(d2)
identical(d1,d2)
}
\seealso{
Other UtilityFuncs: \code{\link{bkfee}},
  \code{\link{blockattime}}, \code{\link{blockstats}},
  \code{\link{date2int}}, \code{\link{int2date}},
  \code{\link{intMaxDay}}, \code{\link{intRangeDay}},
  \code{\link{intRangePeriod}}, \code{\link{timeofblock}},
  \code{\link{txfee}}, \code{\link{txids}},
  \code{\link{txinids}}, \code{\link{txstats}},
  \code{\link{utxoage}}, \code{\link{utxotype}},
  \code{\link{utxovalue}}
}
\author{
Bernhard Pfaff
}
\concept{UtilityFuncs}
