% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/react_spark.R
\name{react_sparkline}
\alias{react_sparkline}
\title{Add a sparkline line chart a reactable table}
\usage{
react_sparkline(
  data,
  height = 22,
  show_line = TRUE,
  line_color = "slategray",
  line_color_ref = NULL,
  line_width = 1,
  line_curve = "cardinal",
  highlight_points = NULL,
  point_size = 1.1,
  labels = "none",
  label_size = "0.8em",
  decimals = 0,
  min_value = NULL,
  max_value = NULL,
  show_area = FALSE,
  area_color = NULL,
  area_color_ref = NULL,
  area_opacity = 0.1,
  statline = NULL,
  statline_color = "red",
  statline_label_size = "0.8em",
  bandline = NULL,
  bandline_color = "red",
  bandline_opacity = 0.2,
  tooltip = TRUE,
  tooltip_type = 1,
  tooltip_color = NULL,
  tooltip_size = "1.1em",
  margin = NULL
)
}
\arguments{
\item{data}{Dataset containing a column with numeric values in a list format.}

\item{height}{Height of the sparkline.
Default is 22.}

\item{show_line}{Logical: show or hide the line.
Default is TRUE.}

\item{line_color}{The color of the line.
Default is slategray.}

\item{line_color_ref}{Optionally assign line colors from another column
by providing the name of the column containing the colors in quotes.
Only one color can be provided per row.
Default is NULL.}

\item{line_width}{Width of the line.
Default is 1.}

\item{line_curve}{The curvature of the line.
Options are 'cardinal', 'linear', 'basis', or 'monotoneX'.
Default is 'cardinal'.}

\item{highlight_points}{Use `highlight_points()` to assign colors to particular points.
Colors can be assigned to all, min, max, first, or last points.
By default, transparent colors are assigned to each point.}

\item{point_size}{Size of the points.
Must first assigned colors to point(s) using `highlight_points`.
Default is 1.1.}

\item{labels}{Show labels for points of interest.
Options are 'min', 'max', 'first', 'last', 'all', or 'none'.
Default is 'none'.}

\item{label_size}{Size of the labels.
Default is '0.8em'.}

\item{decimals}{The number of decimals displayed in the labels and tooltip.
Default is 0.}

\item{min_value}{The minimum value of the sparkline range.
Default is NULL (automatically the minimum value of each sparkline series).}

\item{max_value}{The maximum value of the sparkline range.
Default is NULL (automatically the maximum value of each sparkline series).}

\item{show_area}{Logical: show or hide area beneath line.
Default is FALSE.}

\item{area_color}{The color of the area.
`show_area` must be set to TRUE for color to be shown.
Default is NULL (inherited from line_color).}

\item{area_color_ref}{Optionally assign area colors from another column
by providing the name of the column containing the colors in quotes.
Only one area color can be provided per row.
Default is NULL.
Default is FALSE.}

\item{area_opacity}{A value between 0 and 1 that adjusts the opacity.
A value of 0 is fully transparent, a value of 1 is fully opaque.
Default is 0.1.}

\item{statline}{Inserts a horizontal dotted line representing a statistic,
and places the value of that statistic to the right of the line.
Options are 'mean', 'median', 'min', or 'max'.
Default is NULL.}

\item{statline_color}{The color of the horizontal dotted statline.
Default is red.}

\item{statline_label_size}{The size of the label to the right of the statline.
Default is '0.8em'.}

\item{bandline}{Inserts a horizontal bandline to render ranges of interest.
Options are 'innerquartiles' or 'range' (min to max).
Default is NULL.}

\item{bandline_color}{The color of the bandline.
Default is red.}

\item{bandline_opacity}{A value between 0 and 1 that adjusts the opacity.
A value of 0 is fully transparent, a value of 1 is fully opaque.
Default is 0.2.}

\item{tooltip}{Logical: turn the tooltip on or off.
Default is TRUE.}

\item{tooltip_type}{The tooltip type.
Options are 1 or 2.
Default is 1.}

\item{tooltip_color}{The color of the tooltip labels.
Default is NULL.}

\item{tooltip_size}{The size of the tooltip labels.
Default is '1.1em'.}

\item{margin}{The four-sided margin around the sparkline.
Use margin() to assign the top, right, bottom, and left margins.}
}
\value{
a function that creates a sparkline chart
    from a column containing a list of values.
}
\description{
The `react_sparkline()` function utilizes the {dataui} package <https://github.com/timelyportfolio/dataui> to create an interactive sparkline line chart.
    The data provided must be in a list format.
    The vertical height of the sparkline can be adjusted with `height`. By default, the height is matched to the height of a cell in a reactable table. However, when min/max/all labels are applied, the height is auto-increased to better show the labels. Further adjustment of the height may be needed to better see the patterns in the data.
    The four-sided margin around the sparkline can be controlled with `margin()`. When labels are added to the sparklines, the margin will auto-adjust (in most instances) to be able to display those labels.
    If the labels contain large values or values with many digits, the left and right margins may need to be increased slightly for the full numbers to be visible.
    By default, the sparkline line (the line that connects the data points) is shown but can be hidden by setting `show_line` to FALSE.
    The line color, line width, and line curve can be controlled with `line_color`, `line_width`, and `line_curve` respectively.
    The filled area beneath the line can be shown by setting `show_area` to TRUE. When the area is shown, the area color can be controlled with `area_color` or `area_color_ref` and opacity can be controlled with `area_opacity`.
    `statline` can be used to show a horizontal dotted line that represents either the mean, median, min, or max (your choice).
    The appearance of the statline and statline labels can be controlled with `statline_color` and `statline_label_size`.
    A bandline can be added by using `bandline`. The options are innerquartiles which highlights the innerquartiles of the data or range which highlights the full range of the data.
    By default, `react_sparkline()` is interactive and data points will be shown when hovering over the sparklines. This can be turned off by setting `tooltip` to FALSE.
    There are two tooltip types available within `tooltip_type`. The size and color of the tooltip labels can be adjusted with `tooltip_size` and `tooltip_color`.
    Also by default, there are no labels on the line itself. However, one could add labels to the first, last, min, max, or all values within `labels`.
    The labels that are shown on the sparkline and in the tooltip are automatically rounded to the nearest whole integer. But decimals can be shown by providing the number of decimal places in `decimals`.
    The minimum value of a data series is the minimum value shown for a sparkline, but this can be adjusted with `min_value` and the max can be adjusted with `max_value`.
    `react_sparkline()` should be placed within the cell argument in reactable::colDef.
}
\examples{
\dontrun{
## Default sparkline line chart
library(dplyr)
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkline(.))))

## Highlight min and max data points
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(
 sepal_length = colDef(cell = react_sparkline(.,
 decimals = 1,
 highlight_points = highlight_points(min="red",max="blue")))))

## Add labels to data points and change curvature of line
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkline(.,
 line_curve = "linear",
 decimals = 1,
 highlight_points = highlight_points(first="orange",last="blue"),
 labels = c("first","last")))))

## Conditionally assign line colors to groups
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 mutate(flower_cols = case_when(
   Species == "setosa" ~ "purple",
   Species == "versicolor" ~ "darkgreen",
   Species == "virginica" ~ "orange",
   TRUE ~ "grey"
 )) \%>\%
 reactable(.,
 columns = list(flower_cols = colDef(show=FALSE),
 sepal_length = colDef(cell = react_sparkline(.,
 height = 80,
 line_color_ref = "flower_cols"))))

## Show area beneath the line
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkline(.,
 height = 80,
 line_color = "dodgerblue",
 show_area = TRUE))))

## Conditionally assign colors to the area below the line
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 mutate(flower_cols = case_when(
   Species == "setosa" ~ "purple",
   Species == "versicolor" ~ "darkgreen",
   Species == "virginica" ~ "orange",
   TRUE ~ "grey"
 )) \%>\%
 reactable(.,
 columns = list(flower_cols = colDef(show=FALSE),
 sepal_length = colDef(cell = react_sparkline(.,
 height = 80,
 show_area = TRUE,
 line_color_ref = "flower_cols",
 area_color_ref = "flower_cols"))))

## Add bandline to show innerquartile range
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkline(.,
 height = 80,
 decimals = 1,
 highlight_points = highlight_points(max="red"),
 labels = c("max"),
 bandline = "innerquartiles",
 bandline_color = "darkgreen"))))

## Add statline to show the mean for each sparkline
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkline(.,
 height = 80,
 decimals = 1,
 statline = "mean",
 statline_color = "red"))))

## Combine multiple elements together
iris \%>\%
 group_by(Species) \%>\%
 summarize(sepal_length = list(Sepal.Length)) \%>\%
 reactable(.,
 columns = list(sepal_length = colDef(cell = react_sparkline(.,
 height = 80,
 decimals = 1,
 statline = "mean",
 statline_color = "red",
 bandline = "innerquartiles",
 bandline_color = "darkgreen"))))
}
}
