% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{encoding}
\alias{encoding}
\title{detect the encoding of texts}
\usage{
encoding(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{character vector, corpus, or readtext object whose texts' encodings
will be detected.}

\item{verbose}{if \code{FALSE}, do not print diagnostic report}

\item{...}{additional arguments passed to \link[stringi:stri_enc_detect]{stri_enc_detect}}
}
\description{
Detect the encoding of texts in a character \link{readtext} object and report
on the most likely encoding for each document.  Useful in detecting the
encoding of input texts, so that a source encoding can be (re)specified when
inputting a set of texts using \code{\link[=readtext]{readtext()}}, prior to constructing
a corpus.
}
\details{
Based on \link[stringi:stri_enc_detect]{stri_enc_detect}, which is in turn based on the ICU
libraries.  See the ICU User Guide,
\url{http://userguide.icu-project.org/conversion/detection}.
}
\examples{
\dontrun{encoding(data_char_encodedtexts)
# show detected value for each text, versus known encoding
data.frame(labelled = names(data_char_encodedtexts), 
           detected = encoding(data_char_encodedtexts)$all)

# Russian text, Windows-1251
myreadtext <- readtext("https://kenbenoit.net/files/01_er_5.txt")
encoding(myreadtext)
}
}
