% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P.R
\name{P}
\alias{P}
\title{Manually Create a Test Descriptor Prototype}
\usage{
P(
  value = NULL,
  error = NULL,
  warning = NULL,
  message = NULL,
  stdout = NULL,
  stderr = NULL,
  value_comparer = NULL,
  sides_comparer = NULL
)
}
\arguments{
\item{value}{object (may of course be equipped with attributes)}

\item{error, warning, message}{\link{conditions} expected to occur,
see \code{\link[base]{stop}}, \code{\link[base]{warning}}, and
\code{\link[base]{message}}}

\item{stdout, stderr}{character data expected on
\code{\link[base]{stdout}}
and \code{\link[base]{stderr}}, respectively}

\item{value_comparer, sides_comparer}{optional two-argument functions
which may be used to override the default comparers used by \code{\link{E}}}
}
\value{
A list of class \code{realtest_descriptor}
with named components:
\itemize{
\item \code{value},
\item \code{sides} (optional) -- a list with named elements
    \code{error}, \code{warnings},
    \code{messages}, \code{stdout}, and \code{stderr};
    those which are missing are assumed to be equal to \code{NULL},
\item \code{value_comparer} (optional) -- a function object,
\item \code{sides_comparer} (optional) -- a function object.
}
Other functions are free to add more named components, and do with them
whatever they please.
}
\description{
Allows for formulating expectations like 'the desired outcome is
\code{c(1, 2, 3)}, with a warning' or 'an error should occur'.
}
\details{
If \code{error}, \code{warning}, \code{message}, \code{stdout}, or
\code{stderr} is \code{NULL}, then no side effect of a particular
kind is included in the output.

The semantics is solely defined by the \code{sides_comparer}.
\code{\link{E}} by default uses \code{\link{sides_similar}}
(see its description therein), although you are free to override
it manually or via a global option.
}
\examples{
# the desired outcome is c(1L, 2L, 3L):
P(1:3)
# expecting c(1L, 2L, 3L), with a specific warning:
P(1:3, warning="longer object length is not a multiple of shorter object length")
# note, however, that it is the sides_comparer that defines the semantics

}
\seealso{
The official online manual of \pkg{realtest} at \url{https://realtest.gagolewski.com/}

Related functions:
\code{\link{E}}, \code{\link{R}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
