% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pnpmulti}
\alias{pnpmulti}
\title{Check if multiple points are within a polygon (2D)}
\usage{
pnpmulti(vertx, verty, testx, testy)
}
\arguments{
\item{vertx}{vector of x axis values of polygon corner points}

\item{verty}{vector of y axis values of polygon corner points}

\item{testx}{vector of x axis values of points of interest}

\item{testy}{vector of y axis values of points of interest}
}
\value{
vector with boolean values - TRUE, if the respective point is within the polygon.
Otherwise FALSE.
}
\description{
\code{pnpmulti} works as \code{\link{pnp}} but for multiple points.
}
\examples{
polydf <- data.frame(
  x = c(1,1,2,2),
  y = c(1,2,1,2)
)

testdf <- data.frame(
  x = c(1.5, 2.5),
  y = c(1.5, 2.5)
)

pnpmulti(polydf$x, polydf$y, testdf$x, testdf$y)

}
\seealso{
Other pnpfuncs: \code{\link{pnp}}
}
