% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.recombinator.R, R/recombinator.R
\docType{package}
\name{recombinator}
\alias{recombinator}
\alias{recombinator-package}
\alias{recombinator}
\title{Turn nested lists into data.frames.}
\usage{
recombinator(dat, id = "id")
}
\arguments{
\item{dat}{list. The list of lists to process. It can be in
homogeneous or heterogeneous format (see the description).}

\item{id}{character. Primary key, by default \code{"id"}.}
}
\value{
the converted data.frame. If not a list, no changes will
    be performed.
}
\description{
A mini-utility package for turning nested lists into data.frames.

A recombinator attempts to convert a depth 2 nested list into
a \code{data.frame}.
}
\details{
There are two supported formats.

\enumerate{
  \item{Homogeneous lists}{ A list where the first list element
    is a character vector giving the names of the data.frame,
    and the subsequent list elements themselves lists of values.}
  \item{Heterogeneous lists}{ A list where each element is a named
    list of values. In this format, \code{plyr::rbind} will be used
    to take the union of all names and impute the ones missing
    with \code{NA} values.}
}
}
\note{
A warning will be issued if non-standard names (i.e.
    those containing more than alphanumeric, underscore, and period
    characters) are used.
}
