% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{getIndex}
\alias{getIndex}
\alias{setIndex}
\title{Extract or Set Slice Index}
\usage{
getIndex(x)

setIndex(x, ...)
}
\arguments{
\item{x}{object of class \code{"slice"}}

\item{...}{objects compatible with extracting or replacing a vector}
}
\value{
object of class \code{"slice"}
}
\description{
Functions to obtain or set the index to which a \code{\link{slice}} object points.
}
\examples{
x <- matrix(1:9, nrow=3)
slice_x <- slice(x, 2:3, 1)
identical(getIndex(slice_x), list(2:3, 1)) # TRUE

setIndex(slice_x, list(1, substitute()))
identical(!slice_x, c(1, 4, 7))    # TRUE

}
