% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incr.R
\name{\%.*=\%}
\alias{\%.*=\%}
\title{Matrix Multiplication In Place}
\usage{
x \%.*=\% value
}
\arguments{
\item{x}{object to be modified; can be a symbol, character, or extraction language object.}

\item{value}{value with which to change \code{x} by}
}
\value{
the new value of \code{x}, invisibly
}
\description{
Change the value of an object on the search path through matrix multiplication. Similar to \code{'*='} in
other languages, except with matrix multiplication. See \code{\link{incr}} for details on implementation.
}
\examples{
x <- 1:5
x \%*=\% 6:10
identical(x, 130)  # TRUE
}
