% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regnet-package.R
\docType{package}
\name{regnet-package}
\alias{regnet-package}
\title{Network-Based Regularization for Generalized Linear Models}
\description{
This package provides implementation of the network-based variable selection method proposed in Ren et al (2017) and the robust network-based method for survival response in Ren et al (2019). In addition to network penalty, regnet also allows users to use classical MCP or LASSO penalty.
}
\details{
The easy-to-use, integrated interfaces cv.regnet() and regnet() allow users to flexibly choose the fitting methods they prefer.
There are three arguments control the fitting method
\tabular{rl}{
response: \tab three types of response are supported: "binary", "continuous" \cr \tab and "survival". \cr\cr
penalty: \tab three choices of the penalty functions are available: "network", \cr \tab"mcp" and "lasso".\cr\cr
robust: \tab whether to use robust methods for modeling (Robust methods \cr \tab are only available for survival response for now).
}
In penalized regression, the tuning parameter \eqn{\lambda_{1}} controls the sparsity of the coefficient profile. For network-based methods, an additional tuning parameter \eqn{\lambda_{2}} is needed for controlling the smoothness among coefficient profiles. Typical usage of the package is to have the cv.regnet() compute the optimal values of lambdas, then provide them to the regnet() function for estimating the coefficients

If the users want to include clinical variables that are not subject to penalty in the model, the argument 'clv' can be used to indicate the positions of clinical variables in the X matrix. e.g. 'clv=(1:5)' meaning that the first five variables in X will not be penalized. It is recommended to put the clinical variables at the beginning of the X matrix in a contiguous way (see the 'Value' section of regnet() function). However, non-contiguous indices, e.g. 'clv=(2,4,6)', are also allowed.
}
\examples{
\donttest{
## Survival response using robust network method
data(SurvExample)
X = rgn.surv$X
Y = rgn.surv$Y
clv = c(1:5) # variables 1 to 5 are treated as clinical variables, we choose not to penalize them.
out = cv.regnet(X, Y, response="survival", penalty="network", clv=clv, robust=TRUE, verbo = TRUE)
out$lambda

b = regnet(X, Y, "survival", "network", out$lambda[1,1], out$lambda[1,2], clv=clv, robust=TRUE)
index = which(rgn.surv$beta[-(1:6)] != 0)  # [-(1:6)] removes the intercept and clinical variables
pos = which(b[-(1:6)] != 0)
tp = length(intersect(index, pos))
fp = length(pos) - tp
list(tp=tp, fp=fp)
}

}
\references{
Ren, J., Du, Y., Li, S., Ma, S., Jiang,Y. and Wu, C. (2019). Robust network-based regularization
and variable selection for high dimensional genomics data in cancer prognosis.
\href{https://doi.org/10.1002/gepi.22194}{\emph{Genet. Epidemiol.}, 43:276-291}

Ren, J., He, T., Li, Y., Liu, S., Du, Y., Jiang, Y., and Wu, C. (2017).
Network-based regularization for high dimensional SNP data in the case-control study of
Type 2 diabetes. \href{https://doi.org/10.1186/s12863-017-0495-5}{\emph{BMC Genetics}, 18(1):44}

Wu, C, Jiang, Y, Ren, J, Cui, Y, Ma, S. (2018). Dissecting gene-environment interactions: A penalized robust approach accounting for hierarchical structures.
\href{https://doi.org/10.1002/sim.7518}{\emph{Statistics in Medicine}, 37:437–456}

Wu, C., and Ma, S. (2015). A selective review of robust variable selection with applications in bioinformatics.
\href{http://doi.org/10.1093/bib/bbu046}{\emph{Briefings in Bioinformatics}, 16(5), 873–883}

Wu, C., Shi, X., Cui, Y. and Ma, S. (2015). A penalized robust semiparametric approach for gene-environment interactions.
\href{https://doi.org/10.1002/sim.6609}{\emph{Statistics in Medicine}, 34 (30): 4016–4030}
}
\seealso{
\code{\link{cv.regnet}} \code{\link{regnet}}
}
\keyword{overview}
