% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Claims-class.R
\name{claims}
\alias{claims}
\title{Claims: User constructor function}
\usage{
claims(claims, premiums)
}
\arguments{
\item{claims}{Data.frame. Claims table. Contains at least 2 columns, and may contain 2 optional columns:
\itemize{
 \item{\code{year}: year associated with the considered claim;}
 \item{\code{portfolio}: Optional. Portfolio associated with the considered claim;}
 \item{\code{simulId}: Optional. Simulation id of the considered claim. Useful for stochastic modelling;}
 \item{\code{amount}: amount of the considered claim.}
}}

\item{premiums}{Data.frame. Premiums table. Contains at least 2 columns, and may contain 1 optional column:
\itemize{
 \item{\code{year}: year associated with the considered premium;}
 \item{\code{portfolio}: Optional. Portfolio associated with the considered premium;}
 \item{\code{amount}: amount of the considered premium.}
}}
}
\value{
An object of class \code{Claims} (\code{\link{Claims-class}}), initialized with the values given in input. Its basic methods are:
\itemize{
 \item{\code{show}}
 \item{\code{draw}(\link{draw}): plotting function;}
 \item{\code{summy}(\link{summy}): plotting function;}
 \item{\code{get_claims}(\link{get_claims}): extract claim table from Claims object;}
 \item{\code{get_premiums}(\link{get_premiums}): extract premium table from Claims object;}
 \item{\code{get_commissions}(\link{get_commissions}): extract commissions table from Claims object;}
 \item{\code{get_reinstatements}(\link{get_reinstatements}): extract reinstatements table from Claims object;}
 \item{\code{get_treaties}(\link{get_treaties}): extract applied treaties list from Claims object.}
}
}
\description{
\code{claims} defines an object of class \code{Claims} (\code{\link{Claims-class}}).
}
\details{
If portfolio or simulId are not given in the input tables, the default value is set to 0 in the \code{Claims} object.

Consistency needs to be insured between claims and premiums. For every year where a claim is entered, a premium must be registered. The same goes for the portfolios.

Portfolios differenciation is used to apply reinsurance treaties to different part of claims.

Simulation Ids are used in the case of stochastic simulations, in order to apply reinsurance treaties over simulated claims. Simulations Id are not used for premiums, which are mapped through year and portfolio. Be careful to have a unique premium for each couple year/portfolio.

For a unique combination of year, portfolio and simulId can be associated multiple events that will be taken into account when applying Excess of Loss reinsurance.
}
\examples{
c <- data.frame(year = unlist(sapply(2000:2017, function(x) rep(x, rpois(1,3)))))
c$amount <- pmax(rnorm(nrow(c), 200000, 100000), 0)

p <- aggregate(amount ~ year, c, sum)

claims <- claims(c, p)

}
