% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load}
\alias{load}
\title{Load a Project}
\usage{
load(project = NULL, quiet = FALSE)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{quiet}{Boolean; be quiet during load?}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Load an \code{renv} project.
}
\details{
Calling \code{renv::load()} will set the session's library paths to use a
project-local library, and perform some other work to ensure the project is
properly isolated from other packages on the system.

Normally, \code{renv::load()} is called automatically by the project auto-loader
written to the project \code{.Rprofile} by \code{\link[=init]{init()}}. This allows \R sessions
launched from the root of an \code{renv} project directory to automatically load
that project, without requiring explicit action from the user. However, if
preferred or necessary, one can call \code{renv::load("<project>")} to explicitly
load an \code{renv} project located at a particular path.

Use \code{\link[=activate]{activate()}} to activate (or re-activate) an \code{renv} project, so
that newly-launched \R sessions can automatically load the associated
project.
}
\examples{
\dontrun{

# load a project -- note that this is normally done automatically
# by the project's auto-loader, but calling this explicitly to
# load a particular project may be useful in some circumstances
renv::load()

}
}
