% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{api_error_handler}
\alias{api_error_handler}
\title{Error handler}
\usage{
api_error_handler(.data, fun)
}
\arguments{
\item{.data}{Result of a call to \code{api}}

\item{fun}{A function, either defined in the session, or a function available in loaded
or name-spaced packges}
}
\description{
Error handler
}
\examples{
\dontrun{
# Use functions from httr
api('https://api.github.com/') \%>\%
 api_error_handler(stop_for_status)

api('https://api.github.com/') \%>\%
 api_error_handler(warn_for_status)

# Custom error handling functions
my_stop <- function(x) {
  if (x$status > 200) {
     warning("nope, try again", call. = FALSE)
  }
}
api("http://httpbin.org/status/404") \%>\%
 api_error_handler(my_stop)
}
}
\seealso{
Other dsl: \code{\link{api_body}},
  \code{\link{api_config}}, \code{\link{api_query}},
  \code{\link{api}}, \code{\link{auth}}
}

